<?php
header('Content-Type: application/json');
require '../dbconn.php'; // Ensure this file sets up $conn properly

$response = ["success" => false];

// Get Revenue Trend API
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['start_date']) && isset($_GET['end_date'])) {
    $start_date = $_GET['start_date'];
    $end_date = $_GET['end_date'];

    try {
        $trendQuery = "SELECT DATE_FORMAT(created_at, '%b') AS month, SUM(total_amount) AS sales 
                        FROM orders 
                        WHERE created_at BETWEEN ? AND ?
                        GROUP BY month
                        ORDER BY MIN(created_at)";
        
        $stmt = $conn->prepare($trendQuery);
        $stmt->bind_param("ss", $start_date, $end_date);
        $stmt->execute();
        $result = $stmt->get_result();
        
        $trend = [];
        while ($row = $result->fetch_assoc()) {
            $trend[] = [
                "month" => $row['month'],
                "sales" => (float) $row['sales']
            ];
        }
        
        $response = [
            "success" => true,
            "trend" => $trend
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "error" => $e->getMessage()
        ];
    }

    echo json_encode($response);
}
?>
