<?php
// header("Content-Type: application/json");
// header('Access-Control-Allow-Origin: http://localhost:5173');
// // Allow all origins
// header('Access-Control-Allow-Methods: GET, POST, OPTIONS'); // Allow specific HTTP methods
// header('Access-Control-Allow-Headers: Content-Type, Authorization, Cache-Control'); // Allow specific headers
// header('Content-Type: application/json');
require '../../dbconn.php';
require_once '../../vendor/autoload.php';
require '../../env.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;




$headers = getallheaders();
$authHeader = $headers['Authorization'] ?? '';

if (!$authHeader || !str_starts_with($authHeader, 'Bearer ')) {
    http_response_code(401); // Unauthorized
    echo json_encode(['status' => 'error', 'message' => 'Authorization token missing']);
    exit;
}

$token = str_replace('Bearer ', '', $authHeader);
//$secretKey = "e3ff5f077839c1331b1d893a728246685cb7dba9e3a77bffe7d52eaccf660988";

try {
    $decoded = JWT::decode($token, new Key($secret_key, 'HS256'));
    $user_id = $decoded->sub ?? null; // Extract user ID from token
    if (!$user_id) {
        http_response_code(400); // Unauthorized
        echo json_encode(['status' => 'error', 'message' => 'Invalid token: user ID not found']);
        exit;
    }
} catch (Exception $e) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Token error: ' . $e->getMessage()]);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    //$user_id = isset($_POST['user_id']) ? intval($_POST['user_id']) : 0;
    $notification_id = isset($_POST['notification_id']) ? intval($_POST['notification_id']) : 0;

    if ($user_id > 0 && $notification_id > 0) {
        // Prepare and execute the SQL update query
        $stmt = $conn->prepare("UPDATE notifications SET is_read = 1, read_at = NOW() WHERE id = ? AND user_id = ?");
        $stmt->bind_param("ii", $notification_id, $user_id);
        
        if ($stmt->execute()) {
            echo json_encode(["success" => true, "message" => "Notification marked as read"]);
        } else {
            echo json_encode(["success" => false, "message" => "Failed to update notification"]);
        }
    } else {
        echo json_encode(["success" => false, "message" => "Invalid user ID or notification ID"]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Invalid request method"]);
}
?>
