<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header('Content-Type: application/json');
require_once '../dbconn.php'; // Ensure this file has a function dbConnect()

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

// Validate request method
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Log raw POST data
error_log("Raw POST Data: " . var_export($_POST, true));

// Extract form-data fields
$type = $_POST['type'] ?? '';
$users = $_POST['users'] ?? '';
$code = $_POST['code'] ?? '';
$discount = $_POST['discount'] ?? '';
$valid_until = $_POST['valid_until'] ?? '';

// Validate required fields
if (empty($type) || empty($code) || empty($discount) || empty($valid_until)) {
    echo json_encode(["status" => "error", "message" => "Missing required fields"]);
    exit;
}

// Check if type is valid
$validTypes = ["NEW_PROMOCODE", "PROMOCODE_EXPIRING"];
if (!in_array($type, $validTypes)) {
    echo json_encode(["status" => "error", "message" => "Invalid notification type"]);
    exit;
}

// Establish database connection
// $conn = dbConnect();
if (!$conn) {
    echo json_encode(["status" => "error", "message" => "Database connection failed"]);
    exit;
}

// Get user IDs (supports "all" or specific user IDs)
$userIds = [];
if ($users === "all") {
    $query = "SELECT id FROM users";
    $result = $conn->query($query);
    while ($row = $result->fetch_assoc()) {
        $userIds[] = $row['id'];
    }
} else {
    // Decode user IDs (if provided as a JSON string)
    if (is_string($users)) {
        $decodedUsers = json_decode($users, true);
    } else {
        $decodedUsers = $users; // Assume it's already an array
    }

    if (!is_array($decodedUsers)) {
        echo json_encode(["status" => "error", "message" => "Invalid users data format"]);
        exit;
    }

    $userIds = $decodedUsers;
}

// Ensure users exist
if (empty($userIds)) {
    echo json_encode(["status" => "error", "message" => "No valid users found"]);
    exit;
}

// Prepare SQL statement
$stmt = $conn->prepare("
    INSERT INTO notifications (user_id, type, title, message, deep_link, is_read, created_at)
    VALUES (?, ?, ?, ?, ?, 0, NOW())
");

// Message template
$title = ($type === "NEW_PROMOCODE") ? "New Promo Code!" : "Promo Code Expiring Soon!";
$message = "Use code $code to get $discount off! Valid until $valid_until.";
$deep_link = "app://promocode?code=$code"; // Custom deep link

// Insert notifications
$inserted = 0;
foreach ($userIds as $user_id) {
    $stmt->bind_param("issss", $user_id, $type, $title, $message, $deep_link);
    if ($stmt->execute()) {
        $inserted++;
    }
}

// Close connections
$stmt->close();
$conn->close();

// Response with inserted user IDs
echo json_encode([
    "status" => "success",
    "message" => "Notification sent to $inserted user(s)",
    "sent_to" => $userIds
]);
?>
