<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Content-Type: application/json");
require_once '../dbconn.php';

define("HTTP_METHOD", $_SERVER['REQUEST_METHOD']);

if (HTTP_METHOD !== 'POST') {
    echo json_encode(["success" => false, "error" => "Invalid request method"]);
    exit;
}

# -----------------------------
# VALIDATION
# -----------------------------
if (!isset($_POST['product_ref_id'], $_POST['sku'], $_POST['price'], $_POST['stock_quantity'])) {
    echo json_encode(["success" => false, "error" => "Missing required fields"]);
    exit;
}

$id = isset($_POST['id']) ? intval($_POST['id']) : null;

$product_ref_id        = intval($_POST['product_ref_id']);
$sku                   = mysqli_real_escape_string($conn, $_POST['sku']);
$price                 = floatval($_POST['price']);
$stock_quantity        = intval($_POST['stock_quantity']);
$is_default            = isset($_POST['is_default']) ? intval($_POST['is_default']) : 0;
$in_stock              = isset($_POST['in_stock']) ? intval($_POST['in_stock']) : 1;
$cut_and_clean_price   = isset($_POST['cut_and_clean_price']) ? floatval($_POST['cut_and_clean_price']) : 0;
$name                  = isset($_POST['name']) ? mysqli_real_escape_string($conn, $_POST['name']) : null;
$description           = isset($_POST['description']) ? mysqli_real_escape_string($conn, $_POST['description']) : null;

# -----------------------------
# SPECIFICATIONS JSON
# -----------------------------
$specifications = isset($_POST['specifications']) ? $_POST['specifications'] : "{}";

# -----------------------------
# IMAGE UPLOAD
# -----------------------------
$image_url = null;
if (!empty($_FILES['image']['name'])) {
    $target_dir = "uploads/";
    if (!is_dir($target_dir)) mkdir($target_dir, 0777, true);

    $image_name = basename($_FILES["image"]["name"]);
    $target_file = $target_dir . time() . "_" . $image_name;

    if (move_uploaded_file($_FILES["image"]["tmp_name"], $target_file)) {
        $image_url = "/Admin/product_variants/" . $target_file;
    } else {
        echo json_encode(["success" => false, "error" => "Failed to upload image"]);
        exit;
    }
}

# ------------------------------------------------------------------
# UPDATE
# ------------------------------------------------------------------
if ($id) {

    $query = "
        UPDATE product_variants 
        SET product_ref_id = ?, sku = ?, price = ?, stock_quantity = ?, specifications = ?, 
            is_default = ?, in_stock = ?, name = ?, description = ?, cut_and_clean_price = ?
    ";

    if ($image_url) {
        $query .= ", image_url = ?";
    }

    $query .= " WHERE product_variant_id = ?";

    $stmt = $conn->prepare($query);

    if ($image_url) {
        # WITH IMAGE
        $stmt->bind_param(
            "isdississdsi",
            $product_ref_id,
            $sku,
            $price,
            $stock_quantity,
            $specifications,
            $is_default,
            $in_stock,
            $name,
            $description,
            $cut_and_clean_price,
            $image_url,
            $id
        );
    } else {
        # WITHOUT IMAGE
        $stmt->bind_param(
            "isdississdi",
            $product_ref_id,
            $sku,
            $price,
            $stock_quantity,
            $specifications,
            $is_default,
            $in_stock,
            $name,
            $description,
            $cut_and_clean_price,
            $id
        );
    }

}

# ------------------------------------------------------------------
# INSERT
# ------------------------------------------------------------------
else {

    $query = "
        INSERT INTO product_variants 
        (product_ref_id, sku, price, stock_quantity, image_url, specifications, 
         is_default, in_stock, name, description, cut_and_clean_price)
        VALUES (?, ?, ?, ?, ?, CAST(? AS JSON), ?, ?, ?, ?, ?)
    ";

    $stmt = $conn->prepare($query);

    $stmt->bind_param(
        "isdissiissd",
        $product_ref_id,
        $sku,
        $price,
        $stock_quantity,
        $image_url,
        $specifications,
        $is_default,
        $in_stock,
        $name,
        $description,
        $cut_and_clean_price
    );
}

# -----------------------------
# EXECUTE
# -----------------------------
if ($stmt->execute()) {

    echo json_encode([
        "success" => true,
        "message" => $id ? "Variant updated successfully" : "Variant added successfully",
        "data" => [
            "id" => $id ? $id : $stmt->insert_id,
            "product_ref_id" => $product_ref_id,
            "sku" => $sku,
            "price" => $price,
            "stock_quantity" => $stock_quantity,
            "image_url" => $image_url,
            "specifications" => $specifications,
            "is_default" => $is_default,
            "in_stock" => $in_stock,
            "name" => $name,
            "description" => $description,
            "cut_and_clean_price" => $cut_and_clean_price
        ]
    ]);
} else {
    echo json_encode(["success" => false, "error" => $stmt->error]);
}

$stmt->close();
$conn->close();
?>
