<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require('../dbconn.php'); // Include DB connection

// Set response headers
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Content-Type, Authorization, Cache-Control');
header('Content-Type: application/json');

// Prepare query to fetch all quotes
$query = "SELECT 
            u.id AS user_id, 
            u.name, 
            u.mobile, 
            u.email,
            q.id,
            q.quote_pdf, 
            q.total_price, 
            q.created_at
          FROM quotes q
          INNER JOIN users u ON q.user_id = u.id
          ORDER BY q.created_at DESC";

// Execute the query
$result = $conn->query($query);

// Check if any quotes exist
if ($result->num_rows > 0) {
    $quotes = [];

    // Fetch all quotes
    while ($row = $result->fetch_assoc()) {
        $quotes[] = [
            'user_details' => [
                'user_id' => $row['user_id'],
                'name' => $row['name'],
                'phone' => $row['mobile'],
                'email' => $row['email']
            ],
            'quote_details' => [
                'id' => $row['id'],
                'quote_url' => 'https://sandbox.boltkart.in/API/' . $row['quote_pdf'],
                'total_price' => $row['total_price'],
                'created_at' => $row['created_at']
            ]
        ];
    }

    // Prepare response
    $response = [
        'status' => 'success',
        'total_quotes' => count($quotes),
        'quotes' => $quotes
    ];

    echo json_encode($response);
} else {
    // No quotes found
    echo json_encode([
        'status' => 'error', 
        'message' => 'No quotes found.'
    ]);
}

// Close the database connection
$conn->close();
?>