<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


require('../fpdf.php'); // Include FPDF library
require '../dbconn.php';
require_once '../vendor/autoload.php';
require '../env.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;







$headers = getallheaders();
$authHeader = $headers['Authorization'] ?? '';

if (!$authHeader || !str_starts_with($authHeader, 'Bearer ')) {
    echo json_encode(['status' => 'error', 'message' => 'Authorization token missing']);
    exit;
}

$token = str_replace('Bearer ', '', $authHeader);
//$secretKey = "e3ff5f077839c1331b1d893a728246685cb7dba9e3a77bffe7d52eaccf660988";

try {
    $decoded = JWT::decode($token, new Key($secret_key, 'HS256'));
    $user_id = $decoded->sub ?? null; // Extract user ID from token
    if (!$user_id) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid token: user ID not found']);
        exit;
    }
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => 'Token error: ' . $e->getMessage()]);
    exit;
}

if (isset($user_id)){
    //$user_id = $_POST['user_id'];

    if (!filter_var($user_id, FILTER_VALIDATE_INT)) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid user ID.']);
        exit;
    }

    // Fetch user details first
    $user_query = "SELECT name, mobile, email FROM users WHERE id = ?";
    $user_stmt = $conn->prepare($user_query);
    $user_stmt->bind_param("i", $user_id);
    $user_stmt->execute();
    $user_result = $user_stmt->get_result();

    if ($user_result->num_rows === 0) {
        echo json_encode(['status' => 'error', 'message' => 'User not found.']);
        exit;
    }

    $user_details = $user_result->fetch_assoc();

    // Fetch cart details
    $query = "SELECT temp_cart.id AS cart_id, 
                     products.id AS product_id,
                     products.name AS Name,
                     products.sku, 
                     temp_cart.quantity, 
                     temp_cart.unit_price, 
                     products.image_url
              FROM temp_cart 
              INNER JOIN products ON temp_cart.product_id = products.id 
              WHERE temp_cart.user_id = ? AND temp_cart.is_checked_out = 0";

    if ($stmt = $conn->prepare($query)) {
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $cart_items = [];
            $subtotal = 0;

            while ($row = $result->fetch_assoc()) {
                $row['subtotal'] = $row['quantity'] * $row['unit_price'];
                $subtotal += $row['subtotal'];
                $cart_items[] = $row;
            }

            // GST Calculations
            $gst_rate = 18; // 18% GST
            $sgst = ($subtotal * 9) / 100;
            $cgst = ($subtotal * 9) / 100;
            $total_price = $subtotal + $sgst + $cgst;

            // Generate PDF using FPDF
            class PDF extends FPDF {
                function Header() {
                    // Company logo at the top left
                    $this->Image('logo.png', 20, 10, 30); // Adjust the path and size

                    // Title at center
                    $this->SetFont('Arial', 'B', 14);
                    $this->SetY(30);
                    $this->Cell(0, 10, 'Quotation', 0, 1, 'C');
                }

                function Footer() {
                    $this->SetY(-15);
                    $this->SetFont('Arial', 'I', 10);
                    $this->Cell(0, 10, 'Thank you for shopping with us!', 0, 0, 'C');
                }
            }

            $pdf = new PDF();
            $pdf->AddPage();
            $pdf->SetFont('Arial', 'B', 12);

            // **Adjusting the Y position to center the table on the page**
            $pdf->SetY(42);
            $pdf->SetX(20);// Adjusted to remove space and center the table

            // Table Headers
            $pdf->Cell(60, 10, 'Product Name', 1);
            $pdf->Cell(30, 10, 'SKU', 1);
            $pdf->Cell(20, 10, 'Qty', 1);
            $pdf->Cell(30, 10, 'Unit Price', 1);
            $pdf->Cell(30, 10, 'Subtotal', 1);
            $pdf->Ln();

            // Table Data
            $pdf->SetFont('Arial', '', 12);
            foreach ($cart_items as $item) {
                $pdf->SetX(20); // Ensure the data aligns with the headers
                $pdf->Cell(60, 10, utf8_decode($item['Name']), 1);
                $pdf->Cell(30, 10, $item['sku'], 1);
                $pdf->Cell(20, 10, $item['quantity'], 1);
                $pdf->Cell(30, 10, number_format($item['unit_price'], 2), 1);
                $pdf->Cell(30, 10, number_format($item['subtotal'], 2), 1);
                $pdf->Ln();
            }

            // Subtotal Row
            $pdf->SetFont('Arial', 'B', 12);
            $pdf->SetX(20);
            $pdf->Cell(140, 10, 'Subtotal:', 1, 0, 'R');
            $pdf->Cell(30, 10, number_format($subtotal, 2), 1, 1);

            // GST Breakdown
            $pdf->SetX(20);
            $pdf->Cell(140, 10, 'SGST (9%):', 1, 0, 'R');
            $pdf->Cell(30, 10, number_format($sgst, 2), 1, 1);
            
            $pdf->SetX(20);
            $pdf->Cell(140, 10, 'CGST (9%):', 1, 0, 'R');
            $pdf->Cell(30, 10, number_format($cgst, 2), 1, 1);

            // Total Price Row
            $pdf->SetFont('Arial', '', 12);
            $pdf->SetX(20);
            $pdf->Cell(140, 12, 'Total Price:', 1, 0, 'R');
            $pdf->Cell(30, 12, 'RS. ' . number_format($total_price, 2), 1, 1);

            // Save PDF
            $quote_file = 'quotes/invoice_' . $user_id . '_' . time() . '.pdf';
            $pdf->Output('../' . $quote_file, 'F'); // Save to file

            // Store in database
            $insert_query = "INSERT INTO quotes (user_id, quote_pdf, total_price) VALUES (?, ?, ?)";
            if ($stmt = $conn->prepare($insert_query)) {
                $stmt->bind_param("isd", $user_id, $quote_file, $total_price);
                $stmt->execute();
            }

            echo json_encode([
                'status' => 'success',
                'message' => 'Invoice generated successfully.',
                'quote_url' => 'https://sandbox.boltkart.in/API/' . $quote_file,
                'user_details' => [
                    'name' => $user_details['name'],
                    'phone' => $user_details['mobile'],
                    'email' => $user_details['email']
                ]
                // 'invoice_details' => [
                //     'subtotal' => $subtotal,
                //     'sgst' => $sgst,
                //     'cgst' => $cgst,
                //     'total_price' => $total_price
                // ]
            ]);

        } else {
            echo json_encode(['status' => 'error', 'message' => 'No items found in the cart.']);
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to prepare the query.']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'User ID is required.']);
}

$conn->close();
?>