<?php


header('Access-Control-Allow-Origin: http://localhost:5173');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, Cache-Control');
header('Content-Type: application/json');

require '../dbconn.php';
require_once '../vendor/autoload.php';
require '../env.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

// ----------- Validate JWT Token -----------
$headers = getallheaders();
$authHeader = $headers['Authorization'] ?? '';

if (!$authHeader || !str_starts_with($authHeader, 'Bearer ')) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Authorization token missing']);
    exit;
}

$token = str_replace('Bearer ', '', $authHeader);

try {
    $decoded = JWT::decode($token, new Key($secret_key, 'HS256'));
    $user_id = $decoded->sub ?? null;

    if (!$user_id) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Invalid token: user ID not found']);
        exit;
    }

} catch (Exception $e) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Token error: ' . $e->getMessage()]);
    exit;
}

// ------------ Fetch Cart Data ----------------
if (!filter_var($user_id, FILTER_VALIDATE_INT)) {
    echo json_encode(['success' => false, 'message' => 'Invalid user ID']);
    exit;
}

$query = "
    SELECT 
        temp_cart.id AS cart_id,
        temp_cart.quantity,
        temp_cart.unit_price,
        

        product_variants.product_variant_id AS variant_id,
        product_variants.sku AS variant_sku,
        product_variants.price AS variant_price,
        product_variants.stock_quantity AS variant_stock_quantity,
        product_variants.image_url AS variant_image,
        product_variants.specifications,
        product_variants.is_default,
        product_variants.in_stock,
        product_variants.name AS variant_name,
        product_variants.description,
        product_variants.is_latest,
        product_variants.is_best_seller

    FROM temp_cart
    LEFT JOIN product_variants 
        ON product_variants.product_variant_id = temp_cart.product_id
    WHERE temp_cart.user_id = ?
      AND temp_cart.is_checked_out = 0
";

if ($stmt = $conn->prepare($query)) {
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $cart_items = [];

        while ($row = $result->fetch_assoc()) {
            $cart_items[] = $row;
        }

        echo json_encode([
            'success' => true,
            'data' => $cart_items
        ]);
        exit;
    }

    echo json_encode(['success' => false, 'message' => 'No items found in cart']);
    exit;

} else {
    echo json_encode(['success' => false, 'message' => 'Failed to prepare query']);
    exit;
}

$conn->close();



/* 
header('Access-Control-Allow-Origin: http://localhost:5173');
// Allow all origins
header('Access-Control-Allow-Methods: GET, POST, OPTIONS'); // Allow specific HTTP methods
header('Access-Control-Allow-Headers: Content-Type, Authorization, Cache-Control'); // Allow specific headers
header('Content-Type: application/json');
require '../dbconn.php';
require_once '../vendor/autoload.php';
require '../env.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;




$headers = getallheaders();
$authHeader = $headers['Authorization'] ?? '';

if (!$authHeader || !str_starts_with($authHeader, 'Bearer ')) {
    http_response_code(401); // Unauthorized
    echo json_encode(['status' => 'error', 'message' => 'Authorization token missing']);
    exit;
}

$token = str_replace('Bearer ', '', $authHeader);
//$secretKey = "e3ff5f077839c1331b1d893a728246685cb7dba9e3a77bffe7d52eaccf660988";

try {
    $decoded = JWT::decode($token, new Key($secret_key, 'HS256'));
    $user_id = $decoded->sub ?? null; // Extract user ID from token
    if (!$user_id) {
        http_response_code(400); // Unauthorized
        echo json_encode(['status' => 'error', 'message' => 'Invalid token: user ID not found']);
        exit;
    }
} catch (Exception $e) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Token error: ' . $e->getMessage()]);
    exit;
}

// Check if user_id is provided in the request
if (isset($user_id)) {
    $user_id = $user_id;
    
    // Validate the user_id is an integer (you can improve validation based on your requirements)
    if (filter_var($user_id, FILTER_VALIDATE_INT)) {
        
        // Query to fetch cart items for the user, including additional details
        $query = "SELECT temp_cart.id AS cart_id, 
                         new_products.id AS product_id,
                         new_products.name AS Name,
                         new_products.sku, 
                         product_variants.*
                  FROM temp_cart 
                  INNER JOIN new_products ON temp_cart.product_id = product_variants.id LEFT JOIN product_variants 
    ON product_variants.product_ref_id = new_products.id

                  WHERE temp_cart.user_id = ? AND temp_cart.is_checked_out = 0"; // Excluding checked-out items
        
        // Prepare and execute the query
        if ($stmt = $conn->prepare($query)) {
            $stmt->bind_param("i", $user_id); // Bind user_id as an integer parameter
            $stmt->execute();
            $result = $stmt->get_result();
            
            // Check if cart has items
            if ($result->num_rows > 0) {
                $cart_items = [];
                
                // Fetch cart items
                while ($row = $result->fetch_assoc()) {
                    $cart_items[] = $row;
                }
                
                // Respond with success and the cart items
                echo json_encode([
                    'status' => 'success',
                    'cart_items' => $cart_items,
                ]);
            } else {
                echo json_encode([
                    'status' => 'error',
                    'message' => 'No items found in the cart.',
                ]);
            }
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to prepare the query.',
            ]);
        }
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'Invalid user ID.',
        ]);
    }
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'User ID is required.',
    ]);
}

$conn->close();

*/
?>
