<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once '../dbconn.php';

header("Access-Control-Allow-Origin: http://localhost:5173");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Access-Control-Allow-Credentials: true");
header('Content-Type: application/json');

// Function to sanitize input
function sanitize_input($data) {
    global $conn;
    return mysqli_real_escape_string($conn, trim($data));
}

// Check if it's a POST request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get search term from form data
    $search_term = isset($_POST['search']) ? sanitize_input($_POST['search']) : '';
    
    if (empty($search_term)) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Search term is required',
            'data' => []
        ]);
        exit;
    }

    // Prepare the search query
    $query = "SELECT 
                p.id,
                p.sku,
                p.weight,
                p.sub_category_id,
                p.size,
                p.price,
                p.stock_quantity,
                p.image_url,
                p.width,
                p.height,
                p.slot_width,
                p.coating,
                p.is_default,
                p.in_stock,
                p.material,
                p.making,
                c.name as category_name,
                sc.name as subcategory_name
            FROM 
                products p
            LEFT JOIN 
                sub_categories sc ON p.sub_category_id = sc.id
            LEFT JOIN 
                categories c ON sc.category_id = c.id
            WHERE 
                p.sku LIKE ? 
                OR c.name LIKE ? 
                OR sc.name LIKE ?";

    // Prepare statement
    if ($stmt = $conn->prepare($query)) {
        // Add wildcards to search term
        $search_pattern = "%{$search_term}%";
        
        // Bind parameters for all search conditions
        $stmt->bind_param("sss", $search_pattern, $search_pattern, $search_pattern);
        
        // Execute the query
        if ($stmt->execute()) {
            $result = $stmt->get_result();
            $products = [];
            
            // Fetch all matching products
            while ($row = $result->fetch_assoc()) {
                $products[] = [
                    'id' => $row['id'],
                    'sku' => $row['sku'],
                    'image_url' => $row['image_url'],
                    'sub_category_id' => $row['sub_category_id'],
                    'category_name' => $row['category_name'],
                    'subcategory_name' => $row['subcategory_name'],
                    'price' => $row['price'],
                    'stock_quantity' => $row['stock_quantity'],
                    'weight' => $row['weight'],
                    'size' => $row['size'],
                    'width' => $row['width'],
                    'height' => $row['height'],
                    'slot_width' => $row['slot_width'],
                    'coating' => $row['coating'],
                    'is_default' => $row['is_default'],
                    'in_stock' => $row['in_stock'],
                    'material' => $row['material'],
                    'making' => $row['making']
                ];
            }
            
            // Return success response with products
            echo json_encode([
                'status' => 'success',
                'message' => count($products) . ' products found',
                'data' => $products
            ]);
        } else {
            // Handle execution error
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to execute query: ' . $stmt->error,
                'data' => []
            ]);
        }
        
        // Close statement
        $stmt->close();
    } else {
        // Handle preparation error
        echo json_encode([
            'status' => 'error',
            'message' => 'Failed to prepare query: ' . $conn->error,
            'data' => []
        ]);
    }
} else {
    // Handle invalid request method
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid request method. Only POST requests are allowed.',
        'data' => []
    ]);
}

// Close database connection
$conn->close();
?>